<?php

namespace App\Http\Controllers\API\Features;

use App\Http\Controllers\Controller;
use App\Http\Traits\ResponseTrait;
use App\Models\FeatureAttribute;
use App\Repositries\MainRepository;

class FeatureController extends Controller
{
    use ResponseTrait;
    public $attributeRepository;

    public function __construct(MainRepository $attributeRepository)
    {
        $this->attributeRepository = $attributeRepository;
    }
    public function __invoke($id)
    {
        $attributes = $this->attributeRepository->index(FeatureAttribute::where('feature_id', $id));

        return $this->response(data: $attributes);
    }
}
