<?php

namespace App\Http\Controllers\API\ContactUs;

use App\Http\Controllers\Controller;
use App\Http\Requests\API\ContactUs\ContactUsRequest;
use App\Http\Traits\ResponseTrait;
use App\Models\ContactUs;
use App\Repositries\MainRepository;

class ContactUsController extends Controller
{
    use ResponseTrait;
    public $contactRepository, $model;


    public function __construct(MainRepository $contactRepository, ContactUs $model)
    {
        $this->contactRepository = $contactRepository;
        $this->model = $model;
    }

    public function store(ContactUsRequest $request)
    {

        $contact = $this->contactRepository->create($this->model, $request->validated());

        return $this->response(
            message: __('messages.sended'),
            data: $contact
        );
    }
}
