<?php

namespace App\Http\Controllers\API\Auction;

use App\Http\Controllers\Controller;
use App\Http\Requests\API\Favourite\FavouriteRequest;
use App\Http\Traits\ResponseTrait;
use App\Repositries\MainRepository;

class FavouriteController extends Controller
{
    use ResponseTrait;
    public $favouriteRepository, $model;

    public function __construct(MainRepository $favouriteRepository)
    {
        $this->favouriteRepository = $favouriteRepository;
        $this->model = auth('client')->user()->favourites()->with('country', 'area', 'city','agency');
    }
    public function index()
    {
        $data = $this->favouriteRepository->index($this->model);
        return $this->response(data: $data);
    }

    public function store(FavouriteRequest $request)
    {
        $auction = $this->model->where('auction_id', $request->auction_id)->first();
        if ($auction) {

            $this->model->detach($request->auction_id);
        } else {
            $this->model->attach($request->auction_id);
        }

        return $this->response(message: __('lang.success'));
    }
}
